;******************************************************************************
; Parallax Demo
;******************************************************************************
; A demo of a simple parallax background effect.
;
; This demo uses a modification of the previous scrolling code to create a
; parallax effect against a static background. The code modification isn't
; fully utilised, however, so this is just another example of using the WRAM
; framebuffer.
;
; (C) Kresna Susila - 2018
;******************************************************************************

;------------------------------------------------------------------------------
; Variables
;------------------------------------------------------------------------------
para_anim_counter       =       $7      ; 1 byte
para_rotations_far      =       $8      ; 1 byte
para_rotations_mid      =       $9      ; 1 byte
para_rotations_near     =       $a      ; 1 byte
;------------------------------------------------------------------------------

Parallax_Demo:
        ; Initialise some variables
        mov     #0, para_anim_counter

        ; Draw the original scene
        P_Draw_Background_Constant img_parallax
        P_Blit_Screen

.demo_loop
        ; Calculate if a line should be rotated
        mov     #0, para_rotations_far
        mov     #0, para_rotations_mid
        mov     #1, para_rotations_near

        inc     para_anim_counter
        bp      para_anim_counter, 0, .skip_mid
        mov     #1, para_rotations_mid
.skip_mid

        ld      para_anim_counter
        sub     #4
        bnz     .skip_far
        mov     #1, para_rotations_far
        mov     #0, para_anim_counter
.skip_far

        ; Use our custom function to rotate lines on the screen
        Para_Rotate_Lines 1, 8, para_rotations_far
        Para_Rotate_Lines 10, 8, para_rotations_mid

        ; I'm speeding this rotation up because it always happens
        clr1    ocr, 5
        Para_Rotate_Lines 28, 4, para_rotations_near
        set1    ocr, 5
        P_Blit_Screen

        ; Generic input code to move between demos
        call    Get_Input
        mov     #Button_A, acc
        call    Check_Button_Pressed
        bz      .not_a
        ret
.not_a
        jmp     .demo_loop

%macro  Para_Rotate_Lines %line, %num, %rot
        ;----------------------------------------------------------------------
        ; A small macro to make our function easier to preload.
        ;----------------------------------------------------------------------
        ; Accepts:      Line number (8bit constant)
        ;               Number of lines to rotate (8bit constant)
        ;               Number of rotations (1 byte RAM)
        ; Destroys:     ACC, B, C, TRL, VRMAD1, VRMAD2, VSEL
        ;----------------------------------------------------------------------
        ld      %rot
        st      trl
        mov     #%line, b
        mov     #%num, c
        call    _Para_Rotate_Lines
%end

_Para_Rotate_Lines:
        ;----------------------------------------------------------------------
        ; Rotate lines of the screen by an offset
        ;----------------------------------------------------------------------
        ; This is a modification of our custom function from the earlier demo.
        ; We could have used the other function, but this also lets us scroll
        ; by more than one pixel if desired. However, we don't make use of it.
        ;
        ; Accepts:      B = Starting line number (8bit Constant)
        ;               C = Number of lines to rotate (8bit Constant)
        ;               TRL = Number of rotations
        ; Destroys:     ACC, B, C, TRL, VRMAD1, VRMAD2, VSEL
        ;----------------------------------------------------------------------
        ; If trl = 0, don't rotate
        ld      trl
        bnz     .rotate
        ret
.rotate
        ld      b
        ; Prepare the frame buffer address
        mov     #P_WRAM_BANK, vrmad2
        mov     #%00000000, vsel

        ; Find the line we want to rotate
        ; vrmad1 + (acc * 6)
        ; We're dangerous, so we assume that acc is a valid line number to save
        ; time instead of masking.
        rol
        st      b
        rol
        add     b
        add     #P_WRAM_ADDR
        st      vrmad1

        ; We don't care to clear the carry flag since we're going to set the
        ; first bit later anyway
.new_line
        push    trl

.rotate_line
        ; Preserve the address of the first byte of the line
        push    vrmad1

        ; Rotate through the line
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1
        ld      vtrbf
        rorc
        st      vtrbf
        inc     vrmad1

        pop     vrmad1

        ; Mask the last bit onto the first bit
        xor     acc
        rorc
        st      b
        ld      vtrbf
        or      b
        st      vtrbf

        ; Rotate the line until we run out of rotations
        dbnz    trl, .rotate_line
        pop     trl

        ; Move onto the next line
        ld      vrmad1
        add     #6
        st      vrmad1

        ; If we have no more lines, we're done
        dbnz    c, .new_line
        ret
