;******************************************************************************
; Greyscale Demo
;******************************************************************************
; A demo of using the VMU's slow LCD refresh rate to display more shades.
;
; This demo draws background frames from a LUT using libperspective's
; P_Draw_Background macro.
;
; (C) Kresna Susila - 2018
;******************************************************************************

;------------------------------------------------------------------------------
; Variables
;------------------------------------------------------------------------------
; Greyscale demo variables
gs_bg_address           =       $7      ; 2 bytes
gs_anim_counter         =       $9      ; 1 byte
;------------------------------------------------------------------------------

Greyscale_Demo:
        ; Initialise some variables
        mov     #0, gs_anim_counter
.demo_loop
        ; Use the LUT to find the frame
        clr1    ocr, 5
        mov     #<VMU_Tan_Frame_LUT, trl
        mov     #>VMU_Tan_Frame_LUT, trh
        ld      gs_anim_counter
        rol
        ldc
        st      gs_bg_address
        ld      gs_anim_counter
        rol
        inc     acc
        ldc
        st      gs_bg_address+1

        ; Draw the frame
        P_Draw_Background gs_bg_address
        P_Blit_Screen

        ; Check to see if we need to reset the frame
        inc     gs_anim_counter
        ld      gs_anim_counter
        sub     #7
        bnz     .skip_reset
        mov     #0, gs_anim_counter
.skip_reset
        set1    ocr, 5

        ; Generic input code to move between demos
        call    Get_Input
        mov     #Button_A, acc
        call    Check_Button_Pressed
        bz      .not_a
        ret
.not_a
        jmp     .demo_loop
