;******************************************************************************
; Main ASM file
;******************************************************************************
; An example project using the Perspective drawing library.
;
; This contains 5 examples using libpersective to draw to the screen. The
; examples are (in order):
;       - Sprite_Bounce_Demo
;               A masked sprite moving over a static background.
;       - Custom Drawing Demo
;               A function created to scroll lines that's not built into
;               the library.
;       - Parallax Demo
;               An expansion of the custom drawing demo which does a parallax
;               scrolling effect on a static background.
;       - Greyscale Demo
;               The slow refresh rate of the VMU is exploited to show more
;               shades of grey on the screen in this demo.
;       - Tilemap Demo
;               A complex demo which uses WRAM0 to draw a tilemap using
;               a hack to libperspective's sprite drawing function. The masked
;               sprite can be moved wth the arrow buttons.
;
; (C) Kresna Susila - 2018
;******************************************************************************



;******************************************************************************
; Global Constants & External Libraries
;******************************************************************************

        .include        "./lib/sfr.i"       ; VMU Special Function Register Mapping

;******************************************************************************
; Variables
;******************************************************************************
; Global variables
p3_pressed              =       $4      ; 1 byte
p3_last_input           =       $5      ; 1 byte


;******************************************************************************
; Interrupt Vectors
;******************************************************************************

        .org    $00             ; Main entry point
        jmpf    Start

        .org    $03
        reti

        .org    $0b
        reti

        .org    $13             ; Timer0L
        reti

        .org    $1b
        jmpf    t1int           ; Initialise timer 1

        .org    $23             ; Timer0H
        reti

        .org    $2b
        reti

        .org    $33
        reti

        .org    $3b
        reti

        .org    $43
        reti

        .org    $4b             ; Clear Port 3 Interrupts
        clr1    p3int, 0
        clr1    p3int, 1
        reti

        .org    $130
t1int:
        push    ie
        clr1    ie,7
        not1    ext,0
        jmpf    t1int
        pop     ie
        reti

        .org    $1f0
goodbye:
        not1    ext,0
        jmpf    goodbye         ; leave game mode



;******************************************************************************
; Game Header
;******************************************************************************

        .org   $200
        .include bytes  "header.bin"

;******************************************************************************
; Main Entry Point
;******************************************************************************

        .org    $54B
Start:
        mov     #$a1, ocr
        mov     #%00001001, mcr
        mov     #$80, vccr
        mov     #$20, acc
        push    acc

        mov     #$ff, p3
        mov     #$80, sp
        mov     #%10000000, ie
        clr1    psw, 3
        clr1    psw, 4
        mov     #$05, acc
        push    acc

        mov     #$80, p1fcr
        clr1    p1,7
        mov     #$80, p1ddr

        ; Disable battery check
        clr1    psw, 1
        mov     #$ff, $006E
        set1    psw, 1

        ; ???
        ret

        ; Initialise the p3_last_input
        mov     #%11111111, p3_last_input

Main_Loop:
        call    Sprite_Bounce_Demo
        call    Custom_Drawing_Demo
        call    Parallax_Demo
        call    Greyscale_Demo
        call    Tilemap_Demo
        jmpf    Main_Loop

        .include        "./lib/libperspective.asm"
        .include        "./lib/libkcommon.asm"
        .include        "./src/demo_greyscale.asm"
        .include        "./src/demo_spritebounce.asm"
        .include        "./src/demo_customdraw.asm"
        .include        "./src/demo_parallax.asm"
        .include        "./src/demo_tilemap.asm"
        .include        "./img/tiles.asm"
        .include        "./img/img_background.asm"
        .include        "./img/img_parallax.asm"
        .include        "./img/warning_banner.asm"
        .include        "./img/heart_mask.asm"
        .include        "./img/vmutan_frames.asm"

;******************************************************************************
; End of File
;******************************************************************************
        .cnop   0,$200          ; pad to an even number of blocks
